<?php
	require "config.php";
	include "nav.php";

	if (!isset($_COOKIE['id'])) {
		header("Location: reglog.php");
		exit;
	}
	$felhasznalo_id = $_COOKIE['id'];

	$lekerdezes = "SELECT username FROM users WHERE id=$felhasznalo_id";
	$talalat = $conn->query($lekerdezes);

	if ($talalat && $talalat->num_rows === 1) {
		$felhasznalo = $talalat->fetch_assoc();
		$felhasznalo_nev = $felhasznalo['username'];
	}

// Saját rendezvények lekérése
	$lekerdezes = "
    SELECT * FROM events WHERE user_id=$felhasznalo_id ORDER BY year, month, day, hour, minute
	";
	$talalt_rendezvenyek = $conn->query($lekerdezes);

	$rendezvenyek = [];
	if ($talalt_rendezvenyek && $talalt_rendezvenyek->num_rows > 0) {
		while ($sor = $talalt_rendezvenyek->fetch_assoc()) {
		$rendezvenyek[] = $sor;
	}
}
?>
	<!DOCTYPE html>
	<html lang="hu">
	<head>
		<meta charset="UTF-8">
		<title>Saját rendezvényeim</title>
		<link rel="stylesheet" href="css/styles.css">
	</head>
	<body>

	<h1>Üdv, <?= htmlspecialchars($felhasznalo_nev) ?>!</h1>
	<p>Itt kezelheted a saját rendezvényeidet.</p>
	<a class="btn-primary" href="rendletrehoz.php">+ Új rendezvény</a>

	<h2>Saját rendezvényeim</h2>
	<div class="grid">
	<?php foreach ($rendezvenyek as $rendezveny): ?>
		<?php
			$datum_ido = new DateTime();
			$datum_ido->setDate($rendezveny['year'], $rendezveny['month'], $rendezveny['day']);
			$datum_ido->setTime($rendezveny['hour'], $rendezveny['minute']);
			$datum_szoveg = $datum_ido->format("Y.m.d H:i");

			$kep = $rendezveny['image_path'] ?: 'uploads/events/placeholder.jpg';
		?>
		<div class="card">
			<img src="<?= htmlspecialchars($kep) ?>" alt="">
			<div class="p-16">
			<h3><?= htmlspecialchars($rendezveny['title']) ?></h3>
			<p class="muted"><?= $datum_szoveg ?></p>
			<div class="row">
				<a class="btn" href="rendezveny.php?id=<?= (int)$rendezveny['id'] ?>">Megnyitás</a>
				<a class="btn" href="add_tickets.php?rendezveny_id=<?= (int)$rendezveny['id'] ?>">Jegyek kezelése</a>
			</div>
		</div>
	</div>
<?php endforeach; ?>

<?php if (empty($rendezvenyek)): ?>
	<p>Még nincs rendezvényed.</p>
<?php endif; ?>
</div>

</body>
</html>